/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.resourcestab;

import filenet.sim.api.VWScenarioShiftDefinition;
import filenet.sim.toolkit.designer.properties.IVWSIMPropertyChangeListener;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyChangeEvent;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMShiftInfoPanel;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMShiftsTableModel;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWSplitPane;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.ComponentOrientation;
import java.awt.GridLayout;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class VWSIMShiftsPropertiesTab
extends JPanel
implements IVWSIMPropertyChangeListener,
IVWToolbarBorderActionListener,
ListSelectionListener,
TableModelListener {
    private VWToolbarBorder m_shiftsBorder = null;
    private VWTable m_shiftsTable = null;
    private VWSIMShiftsTableModel m_shiftsTableModel = null;
    private VWSIMShiftInfoPanel m_shiftInfoPanel = null;
    private VWSIMPropertyData m_propertyData = null;

    public void init(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.m_propertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridLayout());
        this.initTableControls();
        this.m_shiftInfoPanel = new VWSIMShiftInfoPanel();
        this.m_shiftInfoPanel.init(this.m_propertyData);
        Locale browserLocale = this.m_propertyData.getSessionInfo().getBrowserLocale();
        ComponentOrientation compOrientation = null;
        compOrientation = browserLocale != null ? ComponentOrientation.getOrientation(browserLocale) : ComponentOrientation.LEFT_TO_RIGHT;
        if (compOrientation.isLeftToRight()) {
            VWSplitPane splitPane = new VWSplitPane(1, this.m_shiftsBorder, this.m_shiftInfoPanel);
            splitPane.setDividerLocation(0.2);
            splitPane.setDividerSize(6);
            splitPane.setResizeWeight(0.5);
            this.add(splitPane);
        } else {
            VWSplitPane splitPane = new VWSplitPane(1, this.m_shiftInfoPanel, this.m_shiftsBorder);
            splitPane.setDividerLocation(0.7);
            splitPane.setDividerSize(6);
            splitPane.setResizeWeight(0.5);
            this.add(splitPane);
        }
        this.reinitialize();
    }

    public void releaseReferences() {
        this.m_shiftsBorder = null;
        this.m_shiftsTable = null;
        this.m_shiftsTableModel = null;
        this.m_shiftInfoPanel = null;
        this.m_propertyData = null;
    }

    public void propertyDataChanged(VWSIMPropertyChangeEvent event) {
        try {
            switch (event.getID()) {
                case 101: {
                    this.reinitialize();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 16: {
                    this.m_shiftsTableModel.addItem();
                    break;
                }
                case 64: {
                    int nSelectedRow = this.m_shiftsTable.getSelectedRow();
                    this.m_shiftsTableModel.copyItem(nSelectedRow);
                    break;
                }
                case 0x10000000: {
                    int nSelectedRow = this.m_shiftsTable.getSelectedRow();
                    this.m_shiftsTableModel.deleteItem(nSelectedRow);
                    break;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (!event.getValueIsAdjusting()) {
                this.updateControls();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int row = event.getLastRow() - 1;
                if (row < 0) {
                    row = 0;
                }
                if (row == this.m_shiftsTable.getSelectedRow()) {
                    this.m_shiftsTable.clearSelection();
                }
                if (row >= 0 && this.m_shiftsTableModel.getRowCount() > 0) {
                    this.m_shiftsTable.setRowSelectionInterval(row, row);
                    break;
                }
                this.updateControls();
            }
        }
    }

    private void initTableControls() {
        this.m_shiftsBorder = new VWToolbarBorder(VWSIMResource.s_shifts, 0x10000050);
        this.m_shiftsBorder.addToolbarBorderActionNotifier(this);
        JPanel shiftsPanel = this.m_shiftsBorder.getClientPanel();
        shiftsPanel.setLayout(new GridLayout());
        this.m_shiftsTableModel = new VWSIMShiftsTableModel(this.m_propertyData);
        this.m_shiftsTableModel.addTableModelListener(this);
        this.m_shiftsTable = new VWTable(this.m_shiftsTableModel);
        this.m_shiftsTable.setRowSelectionAllowed(true);
        this.m_shiftsTable.getSelectionModel().addListSelectionListener(this);
        this.m_shiftsTable.getSelectionModel().setSelectionMode(0);
        this.m_shiftsTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
        this.m_shiftsTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
        shiftsPanel.add(new JScrollPane(this.m_shiftsTable));
    }

    private void reinitialize() {
        this.m_shiftsTableModel.reinitialize();
        this.m_shiftsTable.clearSelection();
        if (this.m_shiftsTableModel.getRowCount() > 0) {
            this.m_shiftsTable.setRowSelectionInterval(0, 0);
        } else {
            this.updateControls();
        }
    }

    private void updateControls() {
        this.m_shiftsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_shiftsBorder.getClientPanel(), 2, 0x10000040));
        int nSelectedRow = this.m_shiftsTable.getSelectedRow();
        if (this.m_shiftsTableModel != null && nSelectedRow != -1) {
            this.m_shiftsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_shiftsBorder.getClientPanel(), 1, Integer.MAX_VALUE));
        }
        VWScenarioShiftDefinition shiftDef = this.m_shiftsTableModel.getItemAt(nSelectedRow);
        this.m_shiftInfoPanel.setShiftDefinition(shiftDef);
    }
}

